/*
uniform sampler2D sampler2d;
varying mediump vec2	varCoord;
void main(void)
{
	gl_FragColor = texture2D(sampler2d,varCoord);
}
*/

varying mediump vec2 varCoord;

uniform sampler2D Sampler;
uniform mediump float Threshold;

const mediump vec3 Perception = vec3(0.299, 0.587, 0.114);

void main(void)
{
    mediump vec3 color = texture2D(Sampler, varCoord).xyz;
    mediump float luminance = dot(Perception, color);
    gl_FragColor = (luminance > Threshold) ? vec4(color, 1) : vec4(0);
}
